import {PLACE_RESERVATION_TYPE} from 'projects/trains/constants/placeReservationType';

import IPrice from 'types/common/price/IPrice';
import {ITrainsCoach} from 'reducers/trains/order/types';
import {ITrainsCoachPlace} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';

export const calculatePlaceTariffMinNonRefundableDiscount = ({
    refundableTariff,
    nonRefundableTariff,
}: {
    refundableTariff: IPrice;
    nonRefundableTariff: IPrice | null;
}): number | undefined => {
    if (!nonRefundableTariff?.value || !refundableTariff?.value) {
        return;
    }

    return Math.round(
        100 - (nonRefundableTariff.value * 100) / refundableTariff.value,
    );
};

export const calculateCoachPlaceMinNonRefundableDiscount = ({
    place,
}: {
    place: ITrainsCoachPlace;
}): number | undefined => {
    const {
        adultTariff,
        childTariff,
        adultNonRefundableTariff,
        childNonRefundableTariff,
    } = place;

    const coachPlaceDiscounts = [];
    const adultTariffDiscount = calculatePlaceTariffMinNonRefundableDiscount({
        refundableTariff: adultTariff,
        nonRefundableTariff: adultNonRefundableTariff,
    });
    const childTariffDiscount = calculatePlaceTariffMinNonRefundableDiscount({
        refundableTariff: childTariff,
        nonRefundableTariff: childNonRefundableTariff,
    });

    if (adultTariffDiscount) {
        coachPlaceDiscounts.push(adultTariffDiscount);
    }

    if (childTariffDiscount) {
        coachPlaceDiscounts.push(childTariffDiscount);
    }

    if (coachPlaceDiscounts.length === 0) {
        return;
    }

    return Math.min(...coachPlaceDiscounts);
};

export const calculateCoachMinNonRefundableDiscount = ({
    coach,
}: {
    coach: ITrainsCoach;
}): number | undefined => {
    const {hasNonRefundableTariff, places, placeReservationType} = coach;

    if (
        !hasNonRefundableTariff ||
        !places ||
        placeReservationType !== PLACE_RESERVATION_TYPE.USUAL
    ) {
        return;
    }

    for (const place of places) {
        const discount = calculateCoachPlaceMinNonRefundableDiscount({place});

        if (discount) {
            return discount;
        }
    }
};
