import {PLACE_RESERVATION_TYPE} from 'projects/trains/constants/placeReservationType';

import {IAdditionalSchemeInfo, ITrainsCoach} from 'reducers/trains/order/types';

/**
 * Проверяет, что схема вагона поддерживает выбор купе целиком.
 */
export default function checkSchemeHasGroupedPlaces(
    coach: ITrainsCoach,
    additionalSchemeInfo: IAdditionalSchemeInfo[],
): boolean {
    const additionalSchemeInfoItem = additionalSchemeInfo.find(
        value => value.index === coach.index,
    );

    // Если можно выбрать только купе целиком
    if (coach.placeReservationType !== PLACE_RESERVATION_TYPE.USUAL) {
        // Проверяем, если нет схемы, то считаем, что можно выбирать купе целиком
        if (coach.schemaId === null) {
            return true;
        }

        // Если схема есть, то проверяем дополнительные флаги для схемы.
        if (additionalSchemeInfoItem) {
            return additionalSchemeInfoItem.hasGroupedPlaces;
        }
    }

    return false;
}
