import {ITrainsCoachServer} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

/**
 * Функция возвращает все ли вагоны имеют название класса обслуживания.
 *
 * @param coaches - вагоны
 */
export default function doAllCoachesHaveServiceClassTitle(
    coaches: ITrainsCoachServer[],
): boolean {
    return (
        coaches.length > 0 &&
        coaches.every(({serviceClass}) =>
            Boolean(serviceClass && serviceClass.title),
        )
    );
}
