import {ITrainsCoach} from 'reducers/trains/order/types';

export const getCoachNonRefundablePlaceNumbers = ({
    coach,
}: {
    coach: ITrainsCoach;
}): number[] => {
    const {hasNonRefundableTariff, places} = coach;

    if (!hasNonRefundableTariff || !places) {
        return [];
    }

    return places.reduce<number[]>((placeNumbers, place) => {
        const {adultNonRefundableTariff, childNonRefundableTariff, number} =
            place;

        if (adultNonRefundableTariff || childNonRefundableTariff) {
            placeNumbers.push(number);
        }

        return placeNumbers;
    }, []);
};
