import {ITrainsCoachPlace} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';

/**
 * Функция возвращает карту мест вагона.
 * Помогает получать место по ключу объекта, а не искать в массиве.
 *
 * @param places - места в вагоне
 */
export default function getCoachPlacesMap(
    places: ITrainsCoachPlace[] | null,
): PartialRecord<number, ITrainsCoachPlace> {
    if (!places) {
        return {};
    }

    return places.reduce<Record<number, ITrainsCoachPlace>>(
        (placesMap, place) => ({
            ...placesMap,
            [place.number]: place,
        }),
        {},
    );
}
