import {ITrainsCoach} from 'reducers/trains/order/types';

/**
 * Функция для генерации названия события для pubsub при взаимодействии с местами на схеме вагона
 *
 * @param eventType - тип события
 * @param coach - вагон
 */
export default function getCoachPlacesPubsubEventName(
    eventType: string,
    coach: ITrainsCoach,
): string {
    const {number, petsAllowed, petInCoach, serviceClass} = coach;

    return `${eventType}_${number}_${petsAllowed}_${petInCoach}_${serviceClass.code}`;
}
