import {ITrainsCoach} from 'reducers/trains/order/types';
import {TCoachesTypeSimpleGroups} from 'projects/trains/components/TrainsOrderPage/SimpleSelectorView/types/TCoachesTypeGroups';

/**
 * Функция возвращает сгруппированные по типу вагоны (плацкарт, купе и и тд)
 * @param coaches - входной список вагонов
 *
 */
export default function getCoachesGroupedByType(
    coaches: ITrainsCoach[],
): TCoachesTypeSimpleGroups {
    return coaches.reduce<TCoachesTypeSimpleGroups>((groups, coach) => {
        const {type} = coach;

        if (!groups[type]) {
            groups[type] = {
                coaches: [],
                type,
            };
        }

        groups[type]?.coaches.push(coach);

        return groups;
    }, {});
}
