import {
    ITrainsCoach,
    ITrainsDetails,
    TrainsPassengersCount,
} from 'reducers/trains/order/types';

import {countPassengersWithPlaces} from 'projects/trains/lib/order/passengers/utils';
import getTrainsMaxAvailablePlacesToPurchaseInCoach from 'projects/trains/lib/order/coaches/getTrainsMaxAvailablePlacesToPurchaseInCoach';

export default function getCoachesWithEnoughPlaces(
    trainDetails: ITrainsDetails | null | undefined,
    passengersCount: TrainsPassengersCount,
): ITrainsCoach[] {
    const coaches = trainDetails?.coaches ?? [];
    const totalPlaceNeed = countPassengersWithPlaces(passengersCount);

    return coaches.filter(coach => {
        const coachPlaces = getTrainsMaxAvailablePlacesToPurchaseInCoach(coach);

        return coachPlaces >= totalPlaceNeed;
    });
}
