import {GENDER_TYPE} from 'projects/trains/constants/genders';
import {MAX_PASSENGERS_COUNT_IN_ORDER} from 'projects/trains/constants/order';

import {ITrainsCoach} from 'reducers/trains/order/types';

import countPlacesByGender from 'projects/trains/lib/order/gender/countPlacesByGender';

/**
 * Функция возвращает максимальное количество мест, которое можно купить в вагоне. Максимум - 4.
 */
export default function getTrainsMaxAvailablePlacesToPurchaseInCoach(
    coach: ITrainsCoach,
): number {
    let coachPlaces = 0;

    if (coach.reservationVariants && coach.reservationVariants.length > 0) {
        coachPlaces = Math.max(
            ...coach.reservationVariants.map<number>(
                variant => variant.placesCount,
            ),
        );
    } else if (coach.places && coach.places.length) {
        const placesByGender = countPlacesByGender(coach);

        if (placesByGender[GENDER_TYPE.SINGLE] > 0) {
            placesByGender[GENDER_TYPE.FEMALE] +=
                placesByGender[GENDER_TYPE.SINGLE];
            placesByGender[GENDER_TYPE.MALE] +=
                placesByGender[GENDER_TYPE.SINGLE];
            placesByGender[GENDER_TYPE.MIXED] +=
                placesByGender[GENDER_TYPE.SINGLE];
        }

        coachPlaces =
            Math.max(...Object.values(placesByGender)) || coach.places.length;
    } else {
        coachPlaces = (coach.placeCounts && coach.placeCounts.total) || 0;
    }

    return Math.min(coachPlaces, MAX_PASSENGERS_COUNT_IN_ORDER);
}
