import {ITrainsCoach} from 'reducers/trains/order/types';

import getTrainsMaxAvailablePlacesToPurchaseInCoach from 'projects/trains/lib/order/coaches/getTrainsMaxAvailablePlacesToPurchaseInCoach';

/**
 * Функция возвращает максимальное количество мест, которое можно купить среди всех вагонов. Максимум - 4.
 */
export default function getTrainsMaxAvailablePlacesToPurchaseInCoaches(
    coaches: ITrainsCoach[],
): number {
    let maxPlaces = 0;

    for (const coach of coaches) {
        const coachPlaces = getTrainsMaxAvailablePlacesToPurchaseInCoach(coach);

        maxPlaces = Math.max(maxPlaces, coachPlaces);
    }

    return maxPlaces;
}
