import {ICoachesClass} from 'projects/trains/components/TrainsOrderPage/SimpleSelectorView/types/TCoachesTypeGroups';

/**
 * Вернёт объект с перечислением всех типов мест для данных классов обслуживания
 *
 * @param classes - агрегированная информация по классам обслуживания
 */
export default function getUniqCoachClassesPlacesTypes(
    classes: ICoachesClass[],
): string[] {
    return Object.keys(
        classes.reduce(
            (types, {placesAndPrices}) => ({
                ...types,
                ...placesAndPrices,
            }),
            {},
        ),
    );
}
