import {ITrainsCoach} from 'reducers/trains/order/types';

/**
 * Функция возвращает признак того, разное ли время прибытия у вагонов.
 */
export default function isTrainsDifferentCoachesArrival(
    coaches: ITrainsCoach[],
): boolean {
    const arrivalTimes = new Set(coaches.map(coach => coach.arrival));

    return arrivalTimes.size > 1;
}
