import minBy from 'lodash/minBy';

import {TCoachPlaceTypesInfo} from 'projects/trains/components/TrainsOrderPage/SimpleSelectorView/types/TCoachesTypeGroups';

/**
 * Функция объединяет боковые места и цены
 *
 * @param placesAndPrices - места и цены всех вагонов определенного класса
 */
export default function setSidePlacesAndPrices(
    placesAndPrices: TCoachPlaceTypesInfo | null,
): TCoachPlaceTypesInfo | null {
    if (!placesAndPrices) {
        return placesAndPrices;
    }

    const sideBottomPlaceAndPrices = placesAndPrices['bottom-side'];
    const sideTopPlaceAndPrices = placesAndPrices['top-side'];

    if (!sideBottomPlaceAndPrices && !sideTopPlaceAndPrices) {
        return placesAndPrices;
    }

    const lowerPrice = minBy(
        [sideBottomPlaceAndPrices, sideTopPlaceAndPrices],
        'minPrice.value',
    );

    if (!lowerPrice) {
        return placesAndPrices;
    }

    placesAndPrices.side = {
        count:
            (sideBottomPlaceAndPrices ? sideBottomPlaceAndPrices.count : 0) +
            (sideTopPlaceAndPrices ? sideTopPlaceAndPrices.count : 0),
        minPrice: lowerPrice.minPrice,
        areAllPricesEqual: Boolean(
            sideBottomPlaceAndPrices?.areAllPricesEqual &&
                sideTopPlaceAndPrices?.areAllPricesEqual &&
                sideBottomPlaceAndPrices.minPrice.value ===
                    sideTopPlaceAndPrices.minPrice.value,
        ),
    };

    delete placesAndPrices['bottom-side'];
    delete placesAndPrices['top-side'];

    return placesAndPrices;
}
