import {ITrainsCoach} from 'reducers/trains/order/types';
import {ITrainsCoachCategory} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';

/**
 * Метод получения списка категорий вагонов
 * @param coaches - массив вагонов
 */
export function getCategories(coaches: ITrainsCoach[]): ITrainsCoachCategory[] {
    const categoryMap = coaches.reduce<Record<string, ITrainsCoachCategory>>(
        (categories, {category}) => {
            categories[category.value] = category;

            return categories;
        },
        {},
    );

    return Object.values(categoryMap);
}
