import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {ITrainsTariffCategory} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {convertTariffTypeToPassengerType} from 'projects/trains/lib/convertPassengerTypeToTariffType';
import {getBoardingAge} from 'utilities/dateUtils/getBoardingAge';

export function getAgeGroup(
    age: number,
    tariffCategories: Nullable<ITrainsTariffCategory[]> | undefined,
): PASSENGERS_TYPES | null {
    const tariffCategory = tariffCategories?.find(
        ({minAge, maxAge}) => age >= minAge && age <= maxAge,
    );

    if (!tariffCategory) {
        return null;
    }

    return convertTariffTypeToPassengerType(tariffCategory.code) ?? null;
}

export function getBoardingAgeGroup(
    birthDate: string,
    departure: string,
    tariffCategories: Nullable<ITrainsTariffCategory[]>,
): PASSENGERS_TYPES | null {
    const boardingAge = getBoardingAge(birthDate, departure);

    return getAgeGroup(boardingAge, tariffCategories);
}
