import memoize from 'lodash/memoize';

import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';
import {TRAIN_BONUS_CARDS} from 'projects/trains/constants/bonusCards';
import {EDocumentType} from 'constants/document/documentTypes';

/**
 * Метод возвращает бонусные карты доступные при использовании указанного типа документа
 * @param documentType - тип документа
 */
export const getAllowedLoyaltyCards = (
    documentType: TRAINS_DOCUMENT_TYPES | EDocumentType | undefined | null,
): TRAIN_BONUS_CARDS[] => {
    switch (documentType) {
        case TRAINS_DOCUMENT_TYPES.MILITARY_CARD:
            return [];
        case TRAINS_DOCUMENT_TYPES.BIRTH_CERTIFICATE:
            return [TRAIN_BONUS_CARDS.BONUS_CARD];
        case EDocumentType.RU_MILITARY_ID:
            return [];
        case EDocumentType.RU_BIRTH_CERTIFICATE:
            return [TRAIN_BONUS_CARDS.BONUS_CARD];
        default:
            return [TRAIN_BONUS_CARDS.BONUS_CARD, TRAIN_BONUS_CARDS.ROAD_CARD];
    }
};

/**
 * Метод фильтрует бонусные карты в зависимости от типа документа
 * @param loyaltyCards - типы бонусных карт доступные для выбранного поезда
 * @param documentType - тип документа
 */
export const getFilteredLoyaltyCards = memoize(
    (
        loyaltyCards: TRAIN_BONUS_CARDS[],
        documentType: TRAINS_DOCUMENT_TYPES | EDocumentType | undefined | null,
    ): TRAIN_BONUS_CARDS[] =>
        getAllowedLoyaltyCards(documentType).filter(cardType =>
            loyaltyCards.includes(cardType),
        ),
    (
        loyaltyCards: TRAIN_BONUS_CARDS[],
        documentType: TRAINS_DOCUMENT_TYPES | EDocumentType,
    ) => `${loyaltyCards}__${documentType}`,
);
