import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

const ALLOWED_DOCUMENT_SYMBOLS = /[a-zA-Z0-9а-яёА-ЯЁ]/;
const ALLOWED_FOREIGN_DOCUMENT_SYMBOLS = /[a-zA-Z0-9а-яёА-ЯЁ-]/;

/**
 * Метод возвращает строку только с разрешенными символами
 * @param value - строка с серией/номером документа
 * @param documentType - тип документа
 */
export function replaceSpecialSymbols(
    value: string,
    documentType: TRAINS_DOCUMENT_TYPES,
): string {
    return (
        value &&
        value
            .split('')
            .filter(symbol =>
                documentType === TRAINS_DOCUMENT_TYPES.FOREIGN_DOCUMENT
                    ? ALLOWED_FOREIGN_DOCUMENT_SYMBOLS.test(symbol)
                    : ALLOWED_DOCUMENT_SYMBOLS.test(symbol),
            )
            .join('')
    );
}
