import {isNotNullable} from 'types/utilities';
import {ITrainPassenger} from 'reducers/trains/order/types';

function hasPassengersDataBonusCard(passengerData: ITrainPassenger[]): boolean {
    return passengerData.some(
        passenger =>
            Object.values(passenger.bonusCards).filter(isNotNullable).length >
            0,
    );
}

export default hasPassengersDataBonusCard;
