import {RUS} from 'constants/form/masks';

import {CHAR_DASH, CHAR_EM_DASH} from 'utilities/strings/charCodes';

export const DASHES = `${CHAR_DASH}${CHAR_EM_DASH}`;

const SEPARATORS = `\\s${DASHES}`;

const SEPARATORS_REGEXP = new RegExp(`[${SEPARATORS}]+`, 'g');

export const EMAIL_MASK = /^\S+@\S+\.\S+$/;

/** TODO: удалить при поддержке свободного формата телефона на бэке */
export const PHONE_NUMBER_MASK = /^[+8][\d()\-\s]{10,}$/;

export const RUS_NAME = `[${RUS}]+([${SEPARATORS}]+[${RUS}]+)*`;

export const BONUS_CARD_MASK = [
    /\d/,
    /\d/,
    /\d/,
    /\d/,
    /\d/,
    /\d/,
    /\d/,
    /\d/,
    /\d/,
    /\d/,
    /\d/,
    /\d/,
    /\d/,
];

/**
 * Функция для очистки строковых значений отправляемых в экспресс3
 * @param value - значение для обработки
 * @return
 */
export function sanitizeName(value: string): string {
    return value ? value.replace(SEPARATORS_REGEXP, CHAR_DASH) : '';
}
