import {DASHES} from 'projects/trains/lib/order/fields/masks';

const DASHES_REGEXP = new RegExp(`[${DASHES}]`, 'g');

/**
 * Проверяем что отчество не задано
 * В данных для записной книжки - null
 * В данных для ИМ - отсутствием отчества является дефис
 *
 * @param patronymic - отчество
 */
export function isPatronymicEmpty(patronymic: string | undefined): boolean {
    return !patronymic || patronymic.replace(DASHES_REGEXP, '').length === 0;
}
