import {CHAR_DASH} from 'utilities/strings/charCodes';

const RUSSIAN_PHONE_NUMBER = /^(\+7|8)\d{10}$/;
const RUSSIAN_PHONE_NUMBER_STARTS_WITH_PLUS = /^\+7\d{10}$/;
const RUSSIAN_PHONE_NUMBER_FORMAT = /^(\+7|8)(\d{3})(\d{3})(\d{2})(\d{2})$/;

/**
 * Вернёт признак является ли номер российским
 * @param {string} number
 * @return {boolean}
 */
function isRussianPhoneNumber(number: string): boolean {
    return RUSSIAN_PHONE_NUMBER.test(number);
}

/**
 * Проверка на то, что строка вида +70123456789
 * @param {string} number
 * @returns {boolean}
 */
export function isRussianPhoneNumberStartsWithPlus(number: string): boolean {
    return RUSSIAN_PHONE_NUMBER_STARTS_WITH_PLUS.test(number);
}

/**
 * Функция форматирования российских номеров
 * @param {string} phoneNumber
 */
export function formatRussianPhoneNumber(phoneNumber: string): string {
    if (!isRussianPhoneNumber(phoneNumber)) {
        return phoneNumber;
    }

    const result = RUSSIAN_PHONE_NUMBER_FORMAT.exec(phoneNumber);

    if (!result) {
        return phoneNumber;
    }

    const parts = result.slice(1);
    const [code, operator, ...number] = parts;

    return `${code} ${operator} ${number.join(CHAR_DASH)}`;
}
