import {TRAINS_DOCUMENT_TYPES} from 'projects/trains/constants/documentTypes';

import * as i18nBlock from 'i18n/trains-order-fields';

/**
 * Вернёт сокращенное или полное наименование документа
 * @param {string} docType - тип документа
 * @return {string}
 */
export function getDocumentTitle(
    docType: TRAINS_DOCUMENT_TYPES | undefined | null,
): string {
    if (!docType) {
        return '';
    }

    return getDocumentShortTitle(docType) || getDocumentFullTitle(docType);
}

export function getDocumentFullTitle(docType: TRAINS_DOCUMENT_TYPES): string {
    switch (docType) {
        case TRAINS_DOCUMENT_TYPES.RUSSIAN_PASSPORT:
            return i18nBlock.documentDashOptionDashRussianDashPassport();
        case TRAINS_DOCUMENT_TYPES.BIRTH_CERTIFICATE:
            return i18nBlock.documentDashOptionDashBirthDashCertificate();
        case TRAINS_DOCUMENT_TYPES.RUSSIAN_INTERNATIONAL_PASSPORT:
            return i18nBlock.documentDashOptionDashRussianDashInternationalDashPassport();
        case TRAINS_DOCUMENT_TYPES.FOREIGN_DOCUMENT:
            return i18nBlock.documentDashOptionDashForeignDashDocument();
        case TRAINS_DOCUMENT_TYPES.SAILOR_PASSPORT:
            return i18nBlock.documentDashOptionDashSailorDashPassport();
        case TRAINS_DOCUMENT_TYPES.MILITARY_CARD:
            return i18nBlock.documentDashOptionDashMilitaryDashCard();
    }
}

function getDocumentShortTitle(docType: TRAINS_DOCUMENT_TYPES): string | null {
    switch (docType) {
        case TRAINS_DOCUMENT_TYPES.BIRTH_CERTIFICATE:
            return i18nBlock.documentDashOptionDashBirthDashCertificateDashShort();
        case TRAINS_DOCUMENT_TYPES.RUSSIAN_INTERNATIONAL_PASSPORT:
            return i18nBlock.documentDashOptionDashRussianDashInternationalDashPassportDashShort();
        case TRAINS_DOCUMENT_TYPES.FOREIGN_DOCUMENT:
            return i18nBlock.documentDashOptionDashForeignDashDocumentDashShort();

        case TRAINS_DOCUMENT_TYPES.RUSSIAN_PASSPORT:
        case TRAINS_DOCUMENT_TYPES.SAILOR_PASSPORT:
        case TRAINS_DOCUMENT_TYPES.MILITARY_CARD:
            return null;
    }
}
