import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {ITrainsCoach} from 'reducers/trains/order/types';

/**
 * Считает количество мест для каждого гендера
 *
 * @param coach - данные о вагоне
 */
export default function countPlacesByGender(
    coach: ITrainsCoach,
): Record<GENDER_TYPE, number> {
    return coach.places.reduce(
        (genderMap, {gender}) => {
            if (!gender) {
                return genderMap;
            }

            return {
                ...genderMap,
                [gender]: (genderMap[gender] || 0) + 1,
            };
        },
        {
            [GENDER_TYPE.FEMALE]: 0,
            [GENDER_TYPE.MALE]: 0,
            [GENDER_TYPE.MIXED]: 0,
            [GENDER_TYPE.SINGLE]: 0,
        },
    );
}
