import uniq from 'lodash/uniq';

import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {ITrainsCoach, TrainsPassengersCount} from 'reducers/trains/order/types';

import isGenderCoach from 'projects/trains/lib/order/gender/isGenderCoach';
import getAvailableGenders from 'projects/trains/lib/order/gender/getAvailableGenders';

/**
 * Функция возвращает все возможные для выбора гендеры для вагонов
 *
 * @param coaches - вагоны
 * @param passengers - пассажиры
 */
export default function getAvailableForSelectGendersForCoaches(
    coaches: ITrainsCoach[],
    passengers: TrainsPassengersCount,
): GENDER_TYPE[] {
    return coaches.reduce<GENDER_TYPE[]>((genders, coach) => {
        if (!isGenderCoach(coach)) {
            return genders;
        }

        return uniq([...genders, ...getAvailableGenders(coach, passengers)]);
    }, []);
}
