import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {ITrainsCoach, TrainsPassengersCount} from 'reducers/trains/order/types';

import countPlacesByGender from 'projects/trains/lib/order/gender/countPlacesByGender';
import {countPassengersWithPlaces} from 'projects/trains/lib/order/passengers/utils';

/**
 * Возвращает доступные варианты гендерного признака с учетом количества пассажиров
 *
 * @param coach - данные вагона
 * @param passengers - данные пассажиров
 */
export default function getAvailableGenders(
    coach: ITrainsCoach,
    passengers: TrainsPassengersCount,
): GENDER_TYPE[] {
    const genders = countPlacesByGender(coach);
    const passengersCount = countPassengersWithPlaces(passengers);

    return [GENDER_TYPE.MALE, GENDER_TYPE.MIXED, GENDER_TYPE.FEMALE].filter(
        gender =>
            genders[GENDER_TYPE.SINGLE] + genders[gender] >= passengersCount,
    );
}
