import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {ITrainsCoach} from 'reducers/trains/order/types';
import {isNotNull} from 'types/utilities';

/**
 * Возвращает основной гендерный признак вагона
 */
export default function getCoachGender(
    coach: ITrainsCoach,
): GENDER_TYPE | null {
    const genders = new Set(
        coach.places.map(({gender}) => gender).filter(isNotNull),
    );

    if (genders.size === 1) {
        if (genders.has(GENDER_TYPE.MALE)) {
            return GENDER_TYPE.MALE;
        }

        if (genders.has(GENDER_TYPE.FEMALE)) {
            return GENDER_TYPE.FEMALE;
        }

        return GENDER_TYPE.MIXED;
    } else if (genders.size > 1) {
        return GENDER_TYPE.MIXED;
    }

    return null;
}
