import {GENDER_TYPE} from 'projects/trains/constants/genders';

import {ITrainsCoach, TrainsPassengersCount} from 'reducers/trains/order/types';

import isGenderCoach from 'projects/trains/lib/order/gender/isGenderCoach';
import getAvailableGenders from 'projects/trains/lib/order/gender/getAvailableGenders';
import isGenderAvailableForSelect from 'projects/trains/lib/order/gender/isGenderAvailableForSelect';

interface IParams {
    passengers: TrainsPassengersCount;
    coach: ITrainsCoach | null;
    gender: GENDER_TYPE | null;
}

/**
 * Возвращает гендерный признак для запроса в УФС
 * Если в вагоне места только одного гендера возвращаем соответствующий гендер,
 * если мест больше - возвращаем выбор пользователя
 * @param {Object} order - данные заказа
 * @returns {String}
 */
export default function getOrderGender({
    passengers,
    coach,
    gender,
}: IParams): GENDER_TYPE | null {
    if (!coach || !isGenderCoach(coach)) {
        return null;
    }

    return isGenderAvailableForSelect(coach, passengers)
        ? gender
        : getAvailableGenders(coach, passengers)[0];
}
