import {ITrainsCoach, TrainsPassengersCount} from 'reducers/trains/order/types';

import getAvailableGenders from 'projects/trains/lib/order/gender/getAvailableGenders';

/**
 * Функция определяет доступен ли селектор выбора гендера купе
 * @param coach - данные вагона
 * @param passengers - структура пассажиров (взрослые/дети/малыши)
 */
export default function isGenderAvailableForSelect(
    coach: ITrainsCoach,
    passengers: TrainsPassengersCount,
): boolean {
    return getAvailableGenders(coach, passengers).length > 1;
}
