import {ITrainsCoach, TrainsPassengersCount} from 'reducers/trains/order/types';

import {makeCacheable} from 'projects/trains/lib/cache';
import sortCoaches from 'projects/trains/lib/order/sortCoaches';
import {countPassengersWithPlaces} from 'projects/trains/lib/order/passengers/utils';

function filterCoaches(
    coaches: ITrainsCoach[],
    passengers: TrainsPassengersCount,
): ITrainsCoach[] {
    const minPlacesCount = countPassengersWithPlaces(passengers);

    return coaches.filter(({places, placeCounts}) => {
        if (places && places.length) {
            return places.length >= minPlacesCount;
        } else if (placeCounts && placeCounts.total) {
            return placeCounts.total >= minPlacesCount;
        }

        return false;
    });
}

function getAutoSelectableCoachWithoutCache(
    coaches: ITrainsCoach[],
    passengers: TrainsPassengersCount,
): ITrainsCoach | null {
    const availableCoaches = filterCoaches(coaches, passengers);

    return sortCoaches(availableCoaches)[availableCoaches.length - 1] || null;
}

/**
 * Вернёт автоматически выбранный вагон
 * В отличии от getSuitableCoach фильтрация проиходит только по кол-ву мест в вагоне
 *
 * @param coaches - данные вагонов
 * @param passengers - данные пассажиров
 */
export const getAutoSelectableCoach = makeCacheable(
    getAutoSelectableCoachWithoutCache,
);
