import get from 'lodash/get';
import sortBy from 'lodash/sortBy';

import {ITrainsCoach} from 'reducers/trains/order/types';
import {ITrainsCoachCategory} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';

import getExtremes from 'projects/trains/lib/getExtremes';
import {makeCacheable} from 'projects/trains/lib/cache';
import {getCategories} from 'projects/trains/lib/order/coachesCategories';
import getCoachesInfo from 'projects/trains/lib/order/getCoachesInfo';
import getCoachesByCategory from 'projects/trains/lib/order/getCoachesByCategory';
import IPrice from 'utilities/currency/PriceInterface';

function getCategoriesDataWithoutCache({coaches}: {coaches: ITrainsCoach[]}): {
    category: ITrainsCoachCategory;
    prices: IPrice[];
    count: number;
}[] {
    return sortBy(
        getCategories(coaches).map(category => ({
            category,
            ...getCoachesInfo(getCoachesByCategory(coaches, category.value)),
        })),
        item => get(getExtremes(item.prices).min, 'value'),
    );
}

export default makeCacheable(getCategoriesDataWithoutCache);
