import {COACH_GENDERS_ABILITIES} from 'projects/trains/constants/coachAbilities';

import {ITrainsCoach} from 'reducers/trains/order/types';
import {ECoachAbility} from 'types/trains/booking/ECoachAbility';

import getCoachGender from 'projects/trains/lib/order/gender/getCoachGender';

/**
 * Функция возвращает гендерную особенность вагона. Нужно для получения списка всех особенностей вагона.
 */
function getGenderAbility({coach}: {coach: ITrainsCoach}): string | null {
    const gender = getCoachGender(coach);

    if (!gender || !COACH_GENDERS_ABILITIES[gender]) {
        return null;
    }

    return COACH_GENDERS_ABILITIES[gender];
}

/**
 * Вернёт массив базовых возможностей для вагона
 */
export default function getCoachClassAbilities({
    coach,
}: {
    coach: ITrainsCoach;
}): string[] {
    const {electronicTicket, owner} = coach;

    const abilities: string[] = [owner];

    if (!electronicTicket) {
        abilities.push(ECoachAbility.NO_ELECTRONIC_REGISTRATION);
    }

    const genderAbility = getGenderAbility({coach});

    if (genderAbility) {
        abilities.push(genderAbility);
    }

    return abilities;
}
