import {ITrainsCoach} from 'reducers/trains/order/types';

import areRequirementsAvailableForCoach from 'projects/trains/lib/order/areRequirementsAvailableForCoach';
import getCoachClassAbilities from 'projects/trains/lib/order/getCoachClassAbilities';
import {getBaseCoachClassKey} from 'projects/trains/lib/order/getBaseCoachClassKey';

/**
 * Вернёт ключ для вагона основываясь его особенностях: класс обслуживания,
 * гендерный признак, признак перевозки животных и прочее.
 */
export default function getCoachClassKey({
    coach,
}: {
    coach: ITrainsCoach;
}): string {
    return [
        getBaseCoachClassKey({coach}),
        coach.schemaId ? 'withSchema' : 'withoutSchema',
        areRequirementsAvailableForCoach({coach})
            ? 'withRequirements'
            : 'withoutRequirements',
        ...getCoachClassAbilities({coach}),
    ].join('-');
}
