import {ITrainsCoach} from 'reducers/trains/order/types';
import {isNotNull} from 'types/utilities';

import getTariffWithBedding from 'projects/trains/lib/order/getTariffWithBedding';
import IPrice from 'utilities/currency/PriceInterface';

/**
 * Функция возвращает информацию для вагона.
 * Информация содержит: количество мест и цены.
 * По умолчанию считаем, что признак белья включен
 *
 * @param coach - вагон
 * @param beddingOption - флаг использования постельного белья
 */
export default function getCoachInfo(
    coach: ITrainsCoach,
    beddingOption: boolean = true,
): {
    count: number;
    prices: IPrice[];
    areAllPricesEqual: boolean;
} {
    const {places, placeCounts} = coach;

    if (places?.length) {
        const prices = places
            .map(({adultTariff}) =>
                getTariffWithBedding(adultTariff, coach, beddingOption),
            )
            .filter(isNotNull);

        return {
            count: places.length,
            prices,
            areAllPricesEqual:
                prices.length > 0 &&
                prices.every(price => prices[0].value === price.value),
        };
    }

    const coachTariff = getTariffWithBedding(
        coach.adultTariff,
        coach,
        beddingOption,
    );

    return {
        count: placeCounts ? placeCounts.total : 0,
        prices: coachTariff ? [coachTariff] : [],
        areAllPricesEqual: false,
    };
}
