import {ITrainsCoach} from 'reducers/trains/order/types';

import {makeCacheable} from 'projects/trains/lib/cache';

function getCoachesByCategoryWithoutCache(
    coaches: ITrainsCoach[],
    category: string,
): ITrainsCoach[] {
    return coaches.filter(coach => coach.category.value === category);
}

export default makeCacheable(getCoachesByCategoryWithoutCache);
