import {TRAIN_COACH_TYPE} from 'projects/trains/constants/coachType';

import {ITrainsCoach} from 'reducers/trains/order/types';

import {makeCacheable} from 'projects/trains/lib/cache';

function getCoachesByTypeWithoutCache(
    coaches: ITrainsCoach[],
    category: TRAIN_COACH_TYPE,
): ITrainsCoach[] {
    return coaches.filter(coach => coach.type === category);
}

const getCoachesByType: typeof getCoachesByTypeWithoutCache = makeCacheable(
    getCoachesByTypeWithoutCache,
);

export default getCoachesByType;
