import {ITrainsCoach} from 'reducers/trains/order/types';

import {makeCacheable} from 'projects/trains/lib/cache';
import getCoachInfo from 'projects/trains/lib/order/getCoachInfo';
import IPrice from 'utilities/currency/PriceInterface';

function getCoachesInfoWithoutCache(
    coaches: ITrainsCoach[],
    beddingOption: boolean = true,
): {
    count: number;
    prices: IPrice[];
} {
    const info = coaches.map(coach => getCoachInfo(coach, beddingOption));

    return {
        count: info.reduce((sum, {count}) => sum + count, 0),
        prices: info.reduce<IPrice[]>(
            (res, {prices}) => [...res, ...prices],
            [],
        ),
    };
}

/**
 * Функция возвращает агрегированную информацию.
 * Информация содержит: количество мест, количество мест различных категорий, минимальную цену.
 *
 * @param coaches - массив объектов вагонов
 * @param beddingOption - признак использования белья
 */
export default makeCacheable(getCoachesInfoWithoutCache);
