import {ITrainsCoach} from 'reducers/trains/order/types';
import {ITrainsOrderLocation} from 'types/trains/booking/ITrainsOrderLocation';
import {EDirection} from 'types/common/EDirection';

import {getBaseCoachClassKey} from 'projects/trains/lib/order/getBaseCoachClassKey';

/**
 * Возвращает вагон, который был указан на шаге выбора мест с точностью до единственности
 *
 * @param coaches - список всех вагонов для поезда
 * @param query - параметры url'а
 * @param serviceClass - класс посчитанный на базе expandedServiceClassKey
 * @param direction - направление поезда (forward/backward)
 * @param index - индекс поезда направления в сложном заказе
 */
const getInitialCoach = ({
    coaches,
    query,
    serviceClass,
    direction,
    index,
}: {
    coaches: ITrainsCoach[];
    query: ITrainsOrderLocation;
    serviceClass: string;
    direction: EDirection;
    index: number;
}): ITrainsCoach | null => {
    const petsAllowed = query.petsAllowed?.[direction]?.[index];
    const coachNumber = query.coachNumber?.[direction]?.[index];

    const availableCoaches = coaches
        .filter(coach => Number(coach.number) === Number(coachNumber))
        .filter(coach => coach.petsAllowed === Boolean(petsAllowed))
        .filter(coach => getBaseCoachClassKey({coach}) === serviceClass);

    return (
        (availableCoaches[0] as typeof availableCoaches[0] | undefined) || null
    );
};

export default getInitialCoach;
