import {ITrainGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';
import {EDirection} from 'types/common/EDirection';
import {TAllSegments} from 'projects/trains/components/TrainsOrderSegments/types';

import {convertGenericOrderServiceToTrainSegment} from './convertGenericOrderServiceToTrainSegment';

export const getOrderSegmentsByGenericOrderServices = (
    services: ITrainGenericService[],
): TAllSegments => {
    return services.reduce<TAllSegments>(
        (allSegments, service) => {
            const {direction, segmentIndex} = service.trainInfo;

            allSegments[direction][segmentIndex] =
                convertGenericOrderServiceToTrainSegment(service);

            return allSegments;
        },
        {
            [EDirection.FORWARD]: {},
            [EDirection.BACKWARD]: {},
        },
    );
};
