import _flatMap from 'lodash/flatMap';

import {ITrainGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';
import ITrainPassenger from 'server/api/GenericOrderApi/types/common/service/ITrainServiceInfo/ITrainPassenger/ITrainPassenger';

export const getOrderTicketsCountByGenericOrderServices = (
    services: ITrainGenericService[],
): number => {
    return _flatMap<ITrainGenericService, ITrainPassenger>(
        services,
        ({trainInfo}) => trainInfo.passengers,
    ).length;
};
