import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';

import {ITrainsTariffCategory} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';

import {convertPassengerTypeToTariffType} from 'projects/trains/lib/convertPassengerTypeToTariffType';

import * as i18nBlock from 'i18n/trains-order-summary-details';

export function getPassengerTypeTitle(
    passengerType: PASSENGERS_TYPES,
    tariffCategories: ITrainsTariffCategory[] | undefined,
): string | null {
    const tariffCategoryType = convertPassengerTypeToTariffType(passengerType);
    const tariffCategory = tariffCategories?.find(
        category => category.code === tariffCategoryType,
    );

    if (!tariffCategory) {
        return null;
    }

    const {minAge, maxAge} = tariffCategory;

    switch (passengerType) {
        case PASSENGERS_TYPES.ADULTS: {
            return i18nBlock.itemDashTitleDashAdults();
        }

        case PASSENGERS_TYPES.CHILDREN: {
            return i18nBlock.itemDashTitleDashChildrenDashNew({
                minAge,
                maxAge,
            });
        }

        case PASSENGERS_TYPES.BABIES: {
            return i18nBlock.itemDashTitleDashBabiesDashNew({age: maxAge});
        }

        default: {
            return null;
        }
    }
}
