import flatMap from 'lodash/flatMap';

import {PASSENGERS_TYPE_ORDER} from 'projects/trains/constants/passengersTypes';

import {
    IAdditionalSchemeInfo,
    ITrainsCoach,
    TrainsPassengersCount,
} from 'reducers/trains/order/types';

import getApproximatedTrainPriceDetails from 'projects/trains/lib/order/getTrainPriceDetails/getApproximatedTrainPriceDetails';

interface IGetPlacesSortedByPrice {
    passengers: TrainsPassengersCount;
    orderPlaces: number[];
    coach: ITrainsCoach | null;
    additionalSchemeInfo: IAdditionalSchemeInfo[];
    nonRefundableTariff: boolean;
    beddingOption: boolean;
}

/**
 * Вернёт список мест отсортированных по стоимости
 */
export function getPlacesSortedByPrice(
    params: IGetPlacesSortedByPrice,
): number[][] {
    const {places} = getApproximatedTrainPriceDetails(params);

    return flatMap(PASSENGERS_TYPE_ORDER, passengersType =>
        places[passengersType].map(({numbers}) => numbers),
    );
}
