import {ITrainsSchema} from 'server/api/TrainsApi/types/ITrainsDetailsApiResponse';
import {ITrainsCoach} from 'reducers/trains/order/types';
import {isNotNull} from 'types/utilities';

import getSchemaByCoach from 'projects/trains/lib/order/getSchemaByCoach';

export default function getSchemasByCoaches(
    coaches: ITrainsCoach[],
    schemas: Record<number, ITrainsSchema>,
): ITrainsSchema[] {
    return [
        ...new Set(
            coaches
                .map(coach => getSchemaByCoach(coach, schemas))
                .filter(isNotNull),
        ),
    ];
}
