import {ITrainsCoach} from 'reducers/trains/order/types';

import getBeddingTariff from 'projects/trains/lib/order/getBeddingTariff';
import IPrice from 'utilities/currency/PriceInterface';

/**
 * Вернёт тариф с учетом постельного белья (если белье выбрано)
 * @param tariff - данные тарифа (стоимость, валюта)
 * @param coach - данные вагона
 * @param beddingOption - признак использования белья
 */
function getTariffWithBedding(
    tariff: IPrice,
    coach: ITrainsCoach,
    beddingOption: boolean,
): IPrice;
function getTariffWithBedding(
    tariff: null,
    coach: ITrainsCoach,
    beddingOption: boolean,
): null;
function getTariffWithBedding(
    tariff: IPrice | null,
    coach: ITrainsCoach,
    beddingOption: boolean,
): IPrice | null {
    if (tariff) {
        const beddingTariffValue = beddingOption ? getBeddingTariff(coach) : 0;

        return {
            value: tariff.value + beddingTariffValue,
            currency: tariff.currency,
        };
    }

    return null;
}

export default getTariffWithBedding;
