import {TrainBookedTariffCode} from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTicket';

import * as i18n from 'i18n/trains-ticket-tariffs';

export default function getTrainBookedTariffText(
    tariffCode: TrainBookedTariffCode,
): string {
    switch (tariffCode) {
        case TrainBookedTariffCode.FAMILY:
            return i18n.family();
        case TrainBookedTariffCode.HAPPY:
            return i18n.happy();
        case TrainBookedTariffCode.SENIOR:
            return i18n.senior();
        case TrainBookedTariffCode.JUNIOR:
            return i18n.junior();
        case TrainBookedTariffCode.PUPIL:
            return i18n.pupil();
        case TrainBookedTariffCode.CHILD_17:
            return i18n.child17();
        case TrainBookedTariffCode.CHILD:
            return i18n.child();
        case TrainBookedTariffCode.BABY:
            return i18n.baby();
        case TrainBookedTariffCode.FULL:
            return i18n.full();
    }
}
