import {ITrainPriceDetails} from 'projects/trains/lib/order/getTrainPriceDetails/types/ITrainPriceDetails';
import {ITrainsCoach} from 'reducers/trains/order/types';

interface IExtendTrainPriceDetailsByBeddingParams {
    coach: ITrainsCoach | null;
    orderPlaces: number[];
    beddingOption: boolean;
}

/**
 * Дополняем цену стоимостью белья
 * @param details
 * @param params
 */
export default function extendTrainPriceDetailsByBedding(
    details: ITrainPriceDetails,
    params: IExtendTrainPriceDetailsByBeddingParams,
): ITrainPriceDetails {
    const {coach, orderPlaces, beddingOption} = params;

    if (!coach) {
        return details;
    }

    const {canChooseBedding, beddingTariff} = coach;

    if (!canChooseBedding) {
        return details;
    }

    const beddingSummary = beddingTariff.value * orderPlaces.length;

    return {
        ...details,
        bedding: {
            ...details.bedding,
            value: beddingSummary,
            single: beddingTariff.value,
        },
        price: {
            ...details.price,
            value: details.price.value + (beddingOption ? beddingSummary : 0),
        },
    };
}
