import {ITrainPriceDetails} from 'projects/trains/lib/order/getTrainPriceDetails/types/ITrainPriceDetails';
import {ITrainGenericService} from 'server/api/GenericOrderApi/types/common/TGenericService';

import {getInsuranceAmountByService} from 'projects/trains/lib/order/insurance';
import sumPrice from 'utilities/price/sumPrice';

interface IExtendTrainPriceDetailsByInsurance {
    trainService: ITrainGenericService;
    insuranceIncluded: boolean;
}

/**
 * Дополняем цену стоимостью страховки
 */
export default function extendTrainPriceDetailsByInsurance(
    details: ITrainPriceDetails,
    params: IExtendTrainPriceDetailsByInsurance,
): ITrainPriceDetails {
    const {trainService, insuranceIncluded} = params;

    if (insuranceIncluded) {
        const insurancePrice = getInsuranceAmountByService(trainService);

        if (!insurancePrice) {
            return details;
        }

        details.price = sumPrice(details.price, insurancePrice);
    }

    return details;
}
