import {PASSENGERS_TYPES} from 'projects/trains/constants/passengersTypes';
import {BASE_CURRENCY} from './constants';

import {TrainBookedTariffCode} from 'server/api/TrainsBookingApi/types/ITrainsOrderInfoTicket';
import {ITrainPriceDetails} from 'projects/trains/lib/order/getTrainPriceDetails/types/ITrainPriceDetails';
import {
    IAdditionalSchemeInfo,
    ITrainsCoach,
    TrainsPassengersCount,
} from 'reducers/trains/order/types';

import getMinOrderPrice from './getMinOrderPrice';

interface IGetInitialTrainPriceDetailsParams<TariffTypes> {
    tariffs: TariffTypes[];
    isApproximatePrice: boolean;
    coach: ITrainsCoach | null;
    additionalSchemeInfo: IAdditionalSchemeInfo[];
    passengers: TrainsPassengersCount;
}

export default function getInitialTrainPriceDetails<
    TariffTypes extends PASSENGERS_TYPES | TrainBookedTariffCode,
>({
    coach,
    isApproximatePrice,
    passengers,
    tariffs,
    additionalSchemeInfo,
}: IGetInitialTrainPriceDetailsParams<TariffTypes>): ITrainPriceDetails {
    const beddingTariff =
        (coach && coach.beddingTariff && coach.beddingTariff.value) || 0;

    const initialPrice = {
        value:
            !coach || coach.schemaId || !isApproximatePrice
                ? 0
                : getMinOrderPrice({passengers, coach, additionalSchemeInfo}),
        currency: BASE_CURRENCY,
    };

    return {
        price: initialPrice,
        refundablePrice: initialPrice,
        nonRefundablePrice: null,
        nonRefundablePlaces: [],
        places: tariffs.reduce(
            (result, item) => ({
                ...result,
                [item]: [],
            }),
            {} as ITrainPriceDetails['places'],
        ),
        bedding: {
            value: beddingTariff,
            single: beddingTariff,
            currency: BASE_CURRENCY,
        },
        coachPlaces: [],
        isPlacesSelectedAtOnce: false,
    };
}
