import {ITrainsCoachPlace} from 'server/services/TrainsService/types/ITrainsDetailsInfoServiceResponse';

import IPrice from 'utilities/currency/PriceInterface';
import {CurrencyType} from 'utilities/currency/CurrencyType';

export interface IPlace {
    title?: string;
    numbers: number[];
    price?: IPrice;
    withoutPlace: boolean;
}

export type TPlaces = Record<string, IPlace[]>;

export interface ITrainPriceDetails {
    price: IPrice;
    refundablePrice: IPrice;
    nonRefundablePrice: IPrice | null;
    nonRefundablePlaces: number[];
    places: TPlaces;
    bedding: {
        value: number;
        single: number;
        currency: CurrencyType;
    };
    coachPlaces: ITrainsCoachPlace[];

    /**
     * Режим выбора сразу нескольких мест. Например, купе-переговорные
     */
    isPlacesSelectedAtOnce: boolean;
}
