import {
    IReservationVariant,
    TrainsPassengersCount,
} from 'reducers/trains/order/types';

export default function getReservationVariantByPassengers(
    reservationVariants: IReservationVariant[],
    passengers: TrainsPassengersCount,
): IReservationVariant | undefined {
    return reservationVariants.find(
        ({passengers: variantPassengers}) =>
            variantPassengers.full === passengers.adults &&
            variantPassengers.child === passengers.children &&
            variantPassengers.baby === passengers.babies,
    );
}
