import {IGenericOrderInfo} from 'server/api/GenericOrderApi/types/common/IGenericOrderInfo';
import {
    ITrainGenericService,
    TGenericService,
} from 'server/api/GenericOrderApi/types/common/TGenericService';

import {isTrainService} from 'projects/trains/lib/order/isTrainService';

export function getTrainServicesByGenericOrderServices(
    services: TGenericService[],
): ITrainGenericService[] {
    return services.filter(isTrainService);
}

export function getTrainServices(
    orderInfo: IGenericOrderInfo | null,
): ITrainGenericService[] {
    if (!orderInfo) {
        return [];
    }

    return getTrainServicesByGenericOrderServices(orderInfo.services);
}
